/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWWorkBasketTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    protected static final int COL_NAME = 0;
    private VWSessionInfo m_sessionInfo = null;
    private VWQueueDefinition m_queueDef = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWWorkBasketTableModel(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.m_rowData = new Vector();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData == null ? 0 : this.m_rowData.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (workBasketDef == null) break;
                    return workBasketDef.getName();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        try {
            try {
                VWWorkBasketDefinition[] workBasketDefs;
                this.m_queueDef = queueDef;
                this.m_rowData = new Vector();
                if (this.m_queueDef != null && (workBasketDefs = this.m_queueDef.getWorkBasketDefinitions()) != null) {
                    for (int nIndex = 0; nIndex < workBasketDefs.length; ++nIndex) {
                        this.m_rowData.addElement(workBasketDefs[nIndex]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                this.m_bIsModified = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            this.m_bIsModified = false;
            throw throwable;
        }
        this.fireTableDataChanged();
        this.m_bIsModified = false;
    }

    protected VWQueueDefinition getQueueDefinition() {
        return this.m_queueDef;
    }

    protected void addNewWorkBasket() throws Exception {
        String newWorkBasketName = VWResource.WorkBasketNameTemplate.toString(Integer.toString(this.getRowCount() + 1));
        VWWorkBasketDefinition newWorkBasketDef = this.m_queueDef.createWorkBasketDefinition(newWorkBasketName);
        this.m_rowData.addElement(newWorkBasketDef);
        this.m_bIsModified = true;
        int nLastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(nLastRow, nLastRow);
    }

    protected void copyWorkBasketAtIndex(int nRowIndex) {
        try {
            String copyOfString;
            VWWorkBasketDefinition newWorkBasketDef;
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            if (workBasketDef != null && (newWorkBasketDef = this.m_queueDef.createCopyOfWorkBasketDefinition(copyOfString = VWResource.CopyOf.toString(workBasketDef.getName()), workBasketDef)) != null) {
                this.m_rowData.addElement(newWorkBasketDef);
                this.m_bIsModified = true;
                int nLastRow = this.getRowCount() - 1;
                this.fireTableRowsInserted(nLastRow, nLastRow);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void deleteWorkBasketAtIndex(int nRowIndex) {
        try {
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            this.m_queueDef.deleteWorkBasketDefinition(workBasketDef.getName());
            this.m_rowData.removeElement(workBasketDef);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected VWWorkBasketDefinition getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWWorkBasketDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected void releaseResources() {
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        this.m_queueDef = null;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            if (workBasketDef != null) {
                workBasketDef.setName((String)aValue);
                this.m_bIsModified = true;
                this.fireTableCellUpdated(nRowIndex, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }
}

